package ru.yandex.direct.core.entity.strategy.service

import ru.yandex.direct.core.entity.strategy.container.StrategyRepositoryContainer
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.repository.StrategyModifyRepository
import ru.yandex.direct.core.entity.strategy.repository.StrategyTypedRepository
import ru.yandex.direct.core.entity.strategy.validation.update.StrategyArchiveValidationService
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.update.ModelStubProvider.getModelStub
import ru.yandex.direct.operation.update.SimpleAbstractUpdateOperation
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class StrategyArchiveUnarchiveOperation(
    private val dataContainer: StrategyRepositoryContainer,
    private val isArchive: Boolean,
    private val strategyArchiveValidationService: StrategyArchiveValidationService,
    private val strategyTypedRepository: StrategyTypedRepository,
    private val strategyModifyRepository: StrategyModifyRepository,
    modelChanges: MutableList<ModelChanges<CommonStrategy>>,
) : SimpleAbstractUpdateOperation<CommonStrategy, Long>(
    Applicability.PARTIAL,
    modelChanges,
    getModelStub(CommonStrategy::class.java, StrategyConstants.STRATEGY_CLASS_TO_TYPE.keys)
) {

    override fun validateModelChanges(modelChangesList: List<ModelChanges<CommonStrategy>>): ValidationResult<List<ModelChanges<CommonStrategy>>, Defect<*>> =
        when {
            isArchive -> strategyArchiveValidationService.validateStrategyArchiveOperation(
                dataContainer,
                modelChangesList
            )
            else -> strategyArchiveValidationService.validateStrategyUnarchiveOperation(dataContainer, modelChangesList)
        }

    override fun getModels(ids: Collection<Long>): Collection<CommonStrategy> {
        return strategyTypedRepository.getTyped(dataContainer.shard, ids)
            .filterIsInstance<CommonStrategy>()
    }

    override fun execute(applicableAppliedChanges: List<AppliedChanges<CommonStrategy>>): List<Long> {
        strategyModifyRepository.update(
            dataContainer,
            applicableAppliedChanges.filter(AppliedChanges<CommonStrategy>::hasActuallyChangedProps)
        )

        return applicableAppliedChanges.map { it.model.id }
    }
}
