package ru.yandex.direct.core.entity.strategy.service;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableBiMap;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgClick;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpa;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerCamp;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerCamp;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpv;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpvCustomPeriod;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressions;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxImpressionsCustomPeriod;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReach;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMaxReachCustomPeriod;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMedia;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekSum;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.model.CpmDefault;
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy;
import ru.yandex.direct.core.entity.strategy.model.PeriodFixBid;
import ru.yandex.direct.core.entity.strategy.model.StrategyAttributionModel;
import ru.yandex.direct.core.entity.strategy.model.StrategyName;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Map.entry;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils.CAMPAIGN_TO_STRATEGY_TYPE;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CLICK;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPA;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPI;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPV;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_CRR;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_MAX_IMPRESSIONS;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_MAX_REACH;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_MEDIA;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_ROI;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.AUTOBUDGET_WEEK_BUNDLE;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.CPM_DEFAULT;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.DEFAULT_;
import static ru.yandex.direct.core.entity.strategy.model.StrategyName.PERIOD_FIX_BID;

@ParametersAreNonnullByDefault
public class StrategyConstants {
    public static final ImmutableBiMap<Class<? extends BaseStrategy>, StrategyName> STRATEGY_CLASS_TO_TYPE =
            new ImmutableBiMap.Builder<Class<? extends BaseStrategy>, StrategyName>()
                    .put(AutobudgetAvgClick.class, AUTOBUDGET_AVG_CLICK)
                    .put(AutobudgetAvgCpcPerCamp.class, AUTOBUDGET_AVG_CPC_PER_CAMP)
                    .put(AutobudgetAvgCpcPerFilter.class, AUTOBUDGET_AVG_CPC_PER_FILTER)
                    .put(AutobudgetAvgCpv.class, AUTOBUDGET_AVG_CPV)
                    .put(AutobudgetAvgCpvCustomPeriod.class, AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD)
                    .put(AutobudgetWeekBundle.class, AUTOBUDGET_WEEK_BUNDLE)
                    .put(AutobudgetAvgCpa.class, AUTOBUDGET_AVG_CPA)
                    .put(AutobudgetAvgCpaPerCamp.class, AUTOBUDGET_AVG_CPA_PER_CAMP)
                    .put(AutobudgetAvgCpaPerFilter.class, AUTOBUDGET_AVG_CPA_PER_FILTER)
                    .put(AutobudgetAvgCpi.class, AUTOBUDGET_AVG_CPI)
                    .put(AutobudgetCrr.class, AUTOBUDGET_CRR)
                    .put(AutobudgetRoi.class, AUTOBUDGET_ROI)
                    .put(AutobudgetWeekSum.class, AUTOBUDGET)
                    .put(DefaultManualStrategy.class, DEFAULT_)
                    .put(AutobudgetMaxImpressions.class, AUTOBUDGET_MAX_IMPRESSIONS)
                    .put(AutobudgetMaxImpressionsCustomPeriod.class, AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD)
                    .put(AutobudgetMaxReach.class, AUTOBUDGET_MAX_REACH)
                    .put(AutobudgetMaxReachCustomPeriod.class, AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD)
                    .put(CpmDefault.class, CPM_DEFAULT)
                    .put(PeriodFixBid.class, PERIOD_FIX_BID)
                    .put(AutobudgetMedia.class, AUTOBUDGET_MEDIA)
                    .build();

    public static final Map<StrategyName, Set<ModelProperty<?, ?>>> PROPERTIES_BY_TYPE =
            Map.ofEntries(
                    entry(AUTOBUDGET_AVG_CLICK, AutobudgetAvgClick.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPC_PER_CAMP, AutobudgetAvgCpcPerCamp.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPC_PER_FILTER, AutobudgetAvgCpcPerFilter.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPV, AutobudgetAvgCpv.allModelProperties()),
                    entry(AUTOBUDGET_WEEK_BUNDLE, AutobudgetWeekBundle.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD, AutobudgetAvgCpvCustomPeriod.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPA, AutobudgetAvgCpa.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPA_PER_CAMP, AutobudgetAvgCpaPerCamp.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPA_PER_FILTER, AutobudgetAvgCpaPerFilter.allModelProperties()),
                    entry(AUTOBUDGET_AVG_CPI, AutobudgetAvgCpi.allModelProperties()),
                    entry(AUTOBUDGET_CRR, AutobudgetCrr.allModelProperties()),
                    entry(AUTOBUDGET_ROI, AutobudgetRoi.allModelProperties()),
                    entry(AUTOBUDGET, AutobudgetWeekSum.allModelProperties()),
                    entry(DEFAULT_, DefaultManualStrategy.allModelProperties()),
                    entry(AUTOBUDGET_MAX_IMPRESSIONS, AutobudgetMaxImpressions.allModelProperties()),
                    entry(AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD,
                            AutobudgetMaxImpressionsCustomPeriod.allModelProperties()),
                    entry(AUTOBUDGET_MAX_REACH, AutobudgetMaxReach.allModelProperties()),
                    entry(AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD, AutobudgetMaxReachCustomPeriod.allModelProperties()),
                    entry(CPM_DEFAULT, CpmDefault.allModelProperties()),
                    entry(PERIOD_FIX_BID, PeriodFixBid.allModelProperties()),
                    entry(AUTOBUDGET_MEDIA, AutobudgetMedia.allModelProperties())
            );

    public static final Map<StrategyName, Set<CampaignType>> CAMPAIGN_TYPES_AVAILABLE_FOR_STRATEGY_TYPES =
            EntryStream.of(CAMPAIGN_TO_STRATEGY_TYPE)
                    .flatMapValues(Set::stream)
                    .mapValues(strategyName -> StrategyName.valueOf(strategyName.name()))
                    .invert()
                    .sortedBy(Map.Entry::getKey)
                    .grouping(Collectors.toSet());

    public static final ImmutableBiMap<StrategyName, Class<? extends BaseStrategy>> STRATEGY_TYPE_TO_CLASS =
            STRATEGY_CLASS_TO_TYPE.inverse();

    public static final Map<StrategyName, Supplier<BaseStrategy>> TYPE_TO_STRATEGY_CLASS_SUPPLIER =
            EntryStream.of(STRATEGY_TYPE_TO_CLASS)
                    .mapValues(x -> (Supplier<BaseStrategy>) () -> {
                        try {
                            return x.getDeclaredConstructor().newInstance();
                        } catch (InstantiationException | IllegalAccessException | InvocationTargetException
                                | NoSuchMethodException e) {
                            throw new RuntimeException(e);
                        }
                    })
                    .toImmutableMap();

    public static final Map<? extends Class<? extends BaseStrategy>, ? extends Set<? extends Class<?
            extends BaseStrategy>>>
            INTERFACES_BY_CLASS = StreamEx.of(STRATEGY_CLASS_TO_TYPE.keySet())
            .mapToEntry(Class::getInterfaces)
            .mapToValue((finalClass, interfaces) -> {
                Set<Class<? extends BaseStrategy>> set = new HashSet<>();
                set.add(finalClass);
                for (Class<?> clazz : interfaces) {
                    if (BaseStrategy.class.isAssignableFrom(clazz) && !isPropHolderClass(clazz)) {
                        Class<? extends BaseStrategy> asSubclass = clazz.asSubclass(BaseStrategy.class);
                        set.add(asSubclass);
                    }
                }
                return set;
            })
            .toMap();

    public static final int MAX_NAME_LENGTH = 255;

    public static final int MAX_UNARCHIVED_STRATEGIES_FOR_CLIENT_NUMBER = 500;

    public static final int MAX_STRATEGIES_FOR_CLIENT_NUMBER = 1500;

    public static final StrategyAttributionModel DEFAULT_ATTRIBUTION_MODEL =
            StrategyAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE;

    public static final Set<StrategyName> AVAILABLE_STRATEGY_TYPES_FOR_PUBLIC_STRATEGY = Set.of(
            AUTOBUDGET_AVG_CLICK,
            AUTOBUDGET_AVG_CPA_PER_CAMP,
            AUTOBUDGET_AVG_CPC_PER_CAMP,
            AUTOBUDGET_AVG_CPA_PER_FILTER,
            AUTOBUDGET_AVG_CPC_PER_FILTER,
            AUTOBUDGET_AVG_CPA,
            AUTOBUDGET,
            AUTOBUDGET_CRR
    );

    public static final Set<CampaignType> AVAILABLE_CAMPAIGN_TYPES_FOR_PUBLIC_STRATEGY = Set.of(
            CampaignType.TEXT,
            CampaignType.DYNAMIC,
            CampaignType.PERFORMANCE,
            CampaignType.MOBILE_CONTENT
    );

    private static boolean isPropHolderClass(Class<?> clazz) {
        String[] packageParts = clazz.getPackage().getName().split("\\.");
        String lastPackagePart = packageParts[packageParts.length - 1];
        return "prop".equals(lastPackagePart);
    }

    public static final int DEFAULT_MAX_NUMBERS_OF_CIDS_ABLE_TO_LINK_TO_PACKAGE_STRATEGY = 100;

    public static final Long AUTOBUDGET_PROFITABILITY_DEFAULT = 0L;

    public static final Set<ModelProperty<? super CommonStrategy, ?>> STRATEGY_PROPERTIES_TO_IGNORE_FOR_CAMPAIGN_CHANGE =
            Set.of(
                    CommonStrategy.LAST_CHANGE,
                    CommonStrategy.NAME,
                    CommonStrategy.CIDS
            );
}
