package ru.yandex.direct.core.entity.strategy.service;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainerService;
import ru.yandex.direct.core.entity.strategy.container.StrategyOperationOptions;
import ru.yandex.direct.core.entity.strategy.container.StrategyRepositoryContainer;
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainerService;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.repository.StrategyModifyRepository;
import ru.yandex.direct.core.entity.strategy.repository.StrategyTypedRepository;
import ru.yandex.direct.core.entity.strategy.service.add.StrategyAddOperation;
import ru.yandex.direct.core.entity.strategy.service.add.StrategyAddOperationService;
import ru.yandex.direct.core.entity.strategy.service.add.StrategyAddOperationTypeSupportFacade;
import ru.yandex.direct.core.entity.strategy.service.update.StrategyUpdateOperation;
import ru.yandex.direct.core.entity.strategy.service.update.StrategyUpdateOperationService;
import ru.yandex.direct.core.entity.strategy.service.update.StrategyUpdateOperationTypeSupportFacade;
import ru.yandex.direct.core.entity.strategy.validation.add.StrategyAddValidationTypeSupportFacade;
import ru.yandex.direct.core.entity.strategy.validation.update.StrategyArchiveValidationService;
import ru.yandex.direct.core.entity.strategy.validation.update.StrategyUpdateValidationTypeSupportFacade;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

@Component
@ParametersAreNonnullByDefault
public class StrategyOperationFactory {

    private final StrategyAddOperationContainerService strategyAddOperationContainerService;
    private final StrategyAddOperationService strategyAddOperationService;

    private final StrategyAddValidationTypeSupportFacade validationTypeSupportFacade;
    private final StrategyAddOperationTypeSupportFacade addOperationTypeSupportFacade;
    private final StrategyTypedRepository strategyTypedRepository;
    private final StrategyModifyRepository strategyModifyRepository;

    private final StrategyUpdateOperationContainerService updateOperationContainerService;
    private final StrategyUpdateOperationService strategyUpdateOperationService;
    private final StrategyUpdateValidationTypeSupportFacade updateValidationTypeSupportFacade;
    private final StrategyUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade;

    private final StrategyArchiveValidationService strategyArchiveValidationService;

    @Autowired
    public StrategyOperationFactory(StrategyAddOperationContainerService strategyAddOperationContainerService,
                                    StrategyAddOperationService strategyAddOperationService,
                                    StrategyAddValidationTypeSupportFacade validationTypeSupportFacade,
                                    StrategyAddOperationTypeSupportFacade addOperationTypeSupportFacade,
                                    StrategyTypedRepository strategyTypedRepository,
                                    StrategyModifyRepository strategyModifyRepository,
                                    StrategyUpdateOperationContainerService updateOperationContainerService,
                                    StrategyUpdateOperationService strategyUpdateOperationService,
                                    StrategyUpdateValidationTypeSupportFacade updateValidationTypeSupportFacade,
                                    StrategyUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade,
                                    StrategyArchiveValidationService strategyArchiveValidationService) {
        this.strategyAddOperationContainerService = strategyAddOperationContainerService;
        this.strategyAddOperationService = strategyAddOperationService;

        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.addOperationTypeSupportFacade = addOperationTypeSupportFacade;

        this.strategyTypedRepository = strategyTypedRepository;
        this.strategyModifyRepository = strategyModifyRepository;

        this.updateOperationContainerService = updateOperationContainerService;
        this.strategyUpdateOperationService = strategyUpdateOperationService;
        this.updateValidationTypeSupportFacade = updateValidationTypeSupportFacade;
        this.updateOperationTypeSupportFacade = updateOperationTypeSupportFacade;
        this.strategyArchiveValidationService = strategyArchiveValidationService;
    }

    public StrategyAddOperation createStrategyAddOperation(int shard,
                                                           Long operatorUid,
                                                           ClientId clientId,
                                                           Long clientUid,
                                                           List<BaseStrategy> models,
                                                           StrategyOperationOptions options) {

        return new StrategyAddOperation(
                Applicability.PARTIAL,
                shard,
                operatorUid,
                clientId,
                clientUid,
                options,
                models,
                strategyAddOperationContainerService,
                strategyAddOperationService,
                validationTypeSupportFacade,
                addOperationTypeSupportFacade);
    }

    public <T extends BaseStrategy> StrategyUpdateOperation<T> createStrategyUpdateOperation(int shard,
                                                                                             ClientId clientId,
                                                                                             Long clientUid,
                                                                                             Long operator,
                                                                                             StrategyOperationOptions operationOptions,
                                                                                             List<ModelChanges<T>> modelChanges,
                                                                                             Class<T> clazz) {
        return new StrategyUpdateOperation<>(
                shard,
                clientId,
                clientUid,
                operator,
                operationOptions,
                modelChanges,
                updateOperationContainerService,
                strategyUpdateOperationService,
                updateValidationTypeSupportFacade,
                updateOperationTypeSupportFacade,
                strategyTypedRepository,
                clazz);
    }

    public StrategyUpdateOperation<CommonStrategy> createStrategyUpdateOperation(int shard,
                                                                                 ClientId clientId,
                                                                                 Long clientUid,
                                                                                 Long operator,
                                                                                 StrategyOperationOptions operationOptions,
                                                                                 List<ModelChanges<CommonStrategy>> modelChanges) {
        return new StrategyUpdateOperation<>(
                shard,
                clientId,
                clientUid,
                operator,
                operationOptions,
                modelChanges,
                updateOperationContainerService,
                strategyUpdateOperationService,
                updateValidationTypeSupportFacade,
                updateOperationTypeSupportFacade,
                strategyTypedRepository,
                CommonStrategy.class);
    }

    public StrategyArchiveUnarchiveOperation createChangeStatusArchiveOperation(int shard,
                                                                                ClientId clientId,
                                                                                List<Long> strategyIds,
                                                                                boolean statusArchive) {
        List<ModelChanges<CommonStrategy>> modelChanges = strategyIds.stream()
                .map(it -> new ModelChanges<>(it, CommonStrategy.class)
                        .process(statusArchive, CommonStrategy.STATUS_ARCHIVED)
                ).collect(Collectors.toList());

        return new StrategyArchiveUnarchiveOperation(
                new StrategyRepositoryContainer(shard, clientId, Collections.emptyMap(), true),
                statusArchive,
                strategyArchiveValidationService,
                strategyTypedRepository,
                strategyModifyRepository,
                modelChanges
        );
    }
}
