package ru.yandex.direct.core.entity.strategy.service.add;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer;
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainerService;
import ru.yandex.direct.core.entity.strategy.container.StrategyOperationOptions;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.validation.add.StrategyAddValidationTypeSupportFacade;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.OperationsUtils;
import ru.yandex.direct.operation.add.AbstractAddOperation;
import ru.yandex.direct.operation.add.ModelsPreValidatedStep;
import ru.yandex.direct.operation.add.ModelsValidatedStep;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@ParametersAreNonnullByDefault
public class StrategyAddOperation extends AbstractAddOperation<BaseStrategy, Long> {
    private final StrategyAddOperationContainerService strategyAddOperationContainerService;
    private final StrategyAddOperationService strategyAddOperationService;
    private final StrategyAddValidationTypeSupportFacade validationTypeSupportFacade;
    private final StrategyAddOperationTypeSupportFacade addOperationTypeSupportFacade;

    private final StrategyAddOperationContainer operationContainer;

    public StrategyAddOperation(Applicability applicability,
                                int shard,
                                Long operatorUid,
                                ClientId clientId,
                                Long clientUid,
                                StrategyOperationOptions options,
                                List<BaseStrategy> models,
                                StrategyAddOperationContainerService strategyAddOperationContainerService,
                                StrategyAddOperationService strategyAddOperationService,
                                StrategyAddValidationTypeSupportFacade validationTypeSupportFacade,
                                StrategyAddOperationTypeSupportFacade addOperationTypeSupportFacade) {
        super(applicability, models);

        this.strategyAddOperationContainerService = strategyAddOperationContainerService;
        this.strategyAddOperationService = strategyAddOperationService;
        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.addOperationTypeSupportFacade = addOperationTypeSupportFacade;

        this.operationContainer = new StrategyAddOperationContainer(
                shard,
                clientId,
                clientUid,
                operatorUid,
                options
        );
    }

    @Override
    public Optional<MassResult<Long>> prepare() {
        strategyAddOperationContainerService.fillContainers(operationContainer, getModels(), null);
        return super.prepare();
    }

    @Override
    protected ValidationResult<List<BaseStrategy>, Defect> preValidate(List<BaseStrategy> models) {
        var vr = new ValidationResult<>(models, Defect.class);
        // превалидация это этап проверки пользовательских изменений. Для мигрирующего ваншота она не нужна.
        if (!operationContainer.getOptions().isCampaignToPackageStrategyOneshot()) {
            validationTypeSupportFacade.preValidate(operationContainer, vr);
        }
        return vr;
    }

    @Override
    protected void onPreValidated(ModelsPreValidatedStep<BaseStrategy> modelsPreValidatedStep) {
        if (!operationContainer.getOptions().isCampaignToPackageStrategyOneshot()) {
            var validModelsMap = modelsPreValidatedStep.getPreValidModelsMap();
            var validModels = List.copyOf(validModelsMap.values());
            addOperationTypeSupportFacade.onPreValidated(operationContainer, validModels);
        }
    }

    @Override
    protected void validate(ValidationResult<List<BaseStrategy>, Defect> preValidationResult) {
        validationTypeSupportFacade.validate(operationContainer, preValidationResult);
    }

    @Override
    protected void onModelsValidated(ModelsValidatedStep<BaseStrategy> modelsValidatedStep) {
        var validModelsMap = modelsValidatedStep.getValidModelsMap();
        var validModels = List.copyOf(validModelsMap.values());
        addOperationTypeSupportFacade.onModelsValidated(operationContainer, validModels);
    }

    @Override
    protected void beforeExecution(Map<Integer, BaseStrategy> validModelsMapToApply) {
        var validStrategiesToApply = List.copyOf(validModelsMapToApply.values());
        addOperationTypeSupportFacade.beforeExecution(operationContainer, validStrategiesToApply);
    }

    @Override
    protected Map<Integer, Long> execute(Map<Integer, BaseStrategy> validModelsMapToApply) {
        return OperationsUtils.applyForMapValues(validModelsMapToApply,
                models -> strategyAddOperationService.execute(operationContainer, models));
    }

}
