package ru.yandex.direct.core.entity.strategy.service.converter;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.model.StrategyName;
import ru.yandex.direct.core.entity.strategy.service.StrategyConstants;
import ru.yandex.direct.core.entity.strategy.utils.StrategyModelUtils;
import ru.yandex.direct.dbutil.model.ClientId;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.multitype.typesupport.TypeSupportUtils.getSupportsByClass;

@Component
@ParametersAreNonnullByDefault
public class CampaignToStrategyConverterFacade {
    private final List<? extends CampaignToStrategyConverterSupport<? extends BaseStrategy>> supports;

    @Autowired
    public CampaignToStrategyConverterFacade(List<?
            extends CampaignToStrategyConverterSupport<? extends BaseStrategy>> supports) {
        this.supports = supports;
    }

    protected BaseStrategy convertCampaignToStrategy(ClientId clientId,
                                                     LocalDateTime now,
                                                     CampaignWithPackageStrategy campaign) {
        StrategyName strategyType = StrategyModelUtils.toStrategyName(campaign.getStrategy().getStrategyName());
        checkState(StrategyConstants.STRATEGY_TYPE_TO_CLASS.containsKey(strategyType), "strategy type: " +
                campaign.getStrategy().getStrategyName() + " is unsupported");
        Class<? extends BaseStrategy> strategyClass = StrategyConstants.STRATEGY_TYPE_TO_CLASS.get(strategyType);
        BaseStrategy strategy = StrategyConstants.TYPE_TO_STRATEGY_CLASS_SUPPLIER.get(strategyType).get();

        getSupportsByClass(supports, strategyClass)
                .forEach(support -> fillTypeSpecificFields(clientId, now, campaign, strategy, support));
        return strategy;
    }

    private void fillTypeSpecificFields(ClientId clientId,
                                        LocalDateTime now,
                                        CampaignWithPackageStrategy campaign,
                                        BaseStrategy strategy,
                                        CampaignToStrategyConverterSupport<? extends BaseStrategy> support) {
        //noinspection unchecked,rawtypes
        ((CampaignToStrategyConverterSupport) support).fillTypeSpecificFields(strategy, clientId, now, campaign);
    }


}
