package ru.yandex.direct.core.entity.strategy.service.converter;

import java.time.LocalDateTime;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bs.common.service.BsOrderIdCalculator;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.utils.NumberUtils;

@Component
public class CampaignToStrategyConverterService {
    private final CampaignToStrategyConverterFacade facade;

    @Autowired
    public CampaignToStrategyConverterService(CampaignToStrategyConverterFacade facade) {
        this.facade = facade;
    }

    public BaseStrategy toStrategyWithIdEqualToCidWithOffset(ClientId clientId, LocalDateTime now,
                                                             CampaignWithPackageStrategy campaign) {
        var strategy = facade.convertCampaignToStrategy(clientId, now, campaign);
        return strategy.withId(getOrderId(campaign.getId()));
    }

    // Для старых кампаний инвариант orderId == cid + ORDER_ID_OFFSET нарушается
    // Поэтому для них вычисляем идентификатор стратегии, как orderId (если он определен) иначе cid + ORDER_ID_OFFSET.
    public BaseStrategy toStrategyWithIdEqualToOrderId(ClientId clientId, LocalDateTime now,
                                                       CampaignWithPackageStrategy campaign) {
        var strategy = facade.convertCampaignToStrategy(clientId, now, campaign);
        var strategyId = NumberUtils.ifNullOrZero(campaign.getOrderId(), getOrderId(campaign.getId()));
        return strategy.withId(strategyId);
    }

    public BaseStrategy toStrategyWithIdEqualToCampaignStrategyId(ClientId clientId, LocalDateTime now,
                                                                  CampaignWithPackageStrategy campaign) {
        var strategy = facade.convertCampaignToStrategy(clientId, now, campaign);
        return strategy.withId(campaign.getStrategyId());
    }

    public BaseStrategy toStrategyWithNotFilledId(ClientId clientId, LocalDateTime now,
                                                  CampaignWithPackageStrategy campaign) {
        return facade.convertCampaignToStrategy(clientId, now, campaign);
    }

    private static Long getOrderId(Long cid) {
        return cid + BsOrderIdCalculator.ORDER_ID_OFFSET;
    }

}
