package ru.yandex.direct.core.entity.strategy.service.converter;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.service.StrategyConstants;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.multitype.typesupport.TypeSupportUtils.getSupportsByClass;

@Component
@ParametersAreNonnullByDefault
public class StrategyToCampaignConverterFacade {
    private final List<? extends StrategyToCampaignConverterSupport<? extends BaseStrategy>> supports;

    @Autowired
    public StrategyToCampaignConverterFacade(List<?
            extends StrategyToCampaignConverterSupport<? extends BaseStrategy>> supports) {
        this.supports = supports;
    }

    public void copyStrategyToCampaign(LocalDateTime now,
                                       BaseStrategy strategy,
                                       CampaignWithPackageStrategy campaign) {
        campaign.setStrategy(null);
        Class<? extends BaseStrategy> strategyClass = StrategyConstants.STRATEGY_TYPE_TO_CLASS.get(strategy.getType());
        getSupportsByClass(supports, strategyClass)
                .forEach(support -> fillCampaignTypeSpecificFields(now, campaign, strategy, support));
    }

    public ModelChanges<CampaignWithPackageStrategy> copyStrategyToCampaignModelChanges(
            LocalDateTime now,
            BaseStrategy strategy,
            ModelChanges<CampaignWithPackageStrategy> modelChanges,
            Class<? extends CampaignWithPackageStrategy> campaignClass) {
        modelChanges.process(null, CampaignWithPackageStrategy.STRATEGY);
        Class<? extends BaseStrategy> strategyClass = StrategyConstants.STRATEGY_TYPE_TO_CLASS.get(strategy.getType());
        getSupportsByClass(supports, strategyClass)
                .forEach(support -> processCampaignModelChangesTypeSpecificProperties(now, modelChanges, strategy,
                        support, campaignClass));
        return modelChanges;
    }

    private void fillCampaignTypeSpecificFields(LocalDateTime now,
                                                CampaignWithPackageStrategy campaign,
                                                BaseStrategy strategy,
                                                StrategyToCampaignConverterSupport<? extends BaseStrategy> support) {
        //noinspection unchecked,rawtypes
        ((StrategyToCampaignConverterSupport) support).fillCampaignTypeSpecificFields(strategy, now, campaign);
    }

    private void processCampaignModelChangesTypeSpecificProperties(LocalDateTime now,
                                                                   ModelChanges<CampaignWithPackageStrategy> modelChanges,
                                                                   BaseStrategy strategy,
                                                                   StrategyToCampaignConverterSupport<?
                                                                           extends BaseStrategy> support,
                                                                   Class<? extends CampaignWithPackageStrategy> campaignClass) {
        //noinspection unchecked,rawtypes
        ((StrategyToCampaignConverterSupport) support).processCampaignModelChangesTypeSpecificProperties(strategy,
                now, modelChanges, campaignClass);
    }
}
