package ru.yandex.direct.core.entity.strategy.service.converter;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.multitype.typesupport.TypeSupport;

@ParametersAreNonnullByDefault
public interface StrategyToCampaignConverterSupport<T extends BaseStrategy> extends TypeSupport<T> {
    void fillCampaignTypeSpecificFields(
            T strategy,
            LocalDateTime now,
            CampaignWithPackageStrategy campaign);

    void processCampaignModelChangesTypeSpecificProperties(
            T strategy,
            LocalDateTime now,
            ModelChanges<CampaignWithPackageStrategy> modelChanges,
            Class<? extends CampaignWithPackageStrategy> campaignClass);
}
