package ru.yandex.direct.core.entity.strategy.service.converter

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.DbStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.model.ModelChanges

class StrategyToCampaignConverterUtils {

    companion object {
        fun createCampaignStrategyIfNull(campaign: CampaignWithPackageStrategy): DbStrategy {
            if (campaign.strategy == null) {
                campaign.strategy = DbStrategy()
            }

            return campaign.strategy
        }

        fun createStrategyDataIfNull(campaign: CampaignWithPackageStrategy): StrategyData {
            val strategy = createCampaignStrategyIfNull(campaign)

            if (strategy.strategyData == null) {
                strategy.strategyData = StrategyData()
            }

            return strategy.strategyData
        }

        fun createCampaignStrategyIfNull(campaignModelChanges: ModelChanges<CampaignWithPackageStrategy>): DbStrategy {
            val campaignStrategy = campaignModelChanges.getPropIfChanged(CampaignWithPackageStrategy.STRATEGY)
            if (campaignStrategy == null) {
                campaignModelChanges.process(DbStrategy(), CampaignWithPackageStrategy.STRATEGY)
            }

            return campaignModelChanges.getChangedProp(CampaignWithPackageStrategy.STRATEGY)!!
        }

        fun createStrategyDataIfNull(campaignModelChanges: ModelChanges<CampaignWithPackageStrategy>): StrategyData {
            val strategy = createCampaignStrategyIfNull(campaignModelChanges)

            if (strategy.strategyData == null) {
                campaignModelChanges.process(
                    strategy.withStrategyData(StrategyData()) as DbStrategy,
                    CampaignWithPackageStrategy.STRATEGY
                )
            }

            return strategy.strategyData
        }
    }
}
