package ru.yandex.direct.core.entity.strategy.service.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.strategy.container.StrategyAdditionalActionsContainer;
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupport;

@ParametersAreNonnullByDefault
public interface StrategyUpdateOperationTypeSupport<S extends BaseStrategy> extends UpdateOperationTypeSupport<S,
        StrategyUpdateOperationContainer, StrategyAdditionalActionsContainer, StrategyUpdateOperationContainer> {

    /**
     * При изменении типа объекта, часть интерфейсов могут не подходить к новому типу.
     * Если интерфейс используется в репозитории -- стоит поддержать очищение полей используемых в репозитории,
     * на случай смены типа.
     * <p>
     * Например, Default использует CONTEXT_LIMIT, а стратегия Crr нет.
     * Тогда при изменении типа с Default на Crr стоит "очистить", заполнить дефолтами неиспользуемые поля,
     * в частности CONTEXT_LIMIT.
     */
    void addModelChangesForCleaningUnsupportedTypeValues(
            StrategyUpdateOperationContainer updateOperationContainer,
            List<ModelChanges<S>> modelChanges);
}
