package ru.yandex.direct.core.entity.strategy.service.update;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.container.StrategyAdditionalActionsContainer;
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.model.StrategyName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupportFacade;
import ru.yandex.direct.multitype.typesupport.TypeSupport;

import static ru.yandex.direct.core.entity.strategy.service.StrategyConstants.STRATEGY_TYPE_TO_CLASS;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class StrategyUpdateOperationTypeSupportFacade
        extends UpdateOperationTypeSupportFacade<BaseStrategy, StrategyUpdateOperationContainer,
        StrategyAdditionalActionsContainer, StrategyUpdateOperationContainer> {
    public StrategyUpdateOperationTypeSupportFacade(List<StrategyUpdateOperationTypeSupport<? extends BaseStrategy>> supports) {
        super(supports, Set.of(CommonStrategy.class));
    }

    public List<? extends ModelChanges<? extends BaseStrategy>> addModelChangesForCleaningUnsupportedTypeValues(
            StrategyUpdateOperationContainer updateContainer,
            Collection<? extends BaseStrategy> oldModels,
            Map<Long, StrategyName> changedStrategyTypeById) {
        List<? extends ModelChanges<? extends BaseStrategy>> modelChanges = EntryStream.of(changedStrategyTypeById)
                .mapKeyValue((id, strategyName) -> new ModelChanges<>(id, STRATEGY_TYPE_TO_CLASS.get(strategyName)))
                .toList();

        getIdsForCleaningGroupedByTypeSupports(updateContainer, oldModels, modelChanges)
                .forEach((support, supportedIds) -> addModelChangesForCleaningUnsupportedTypeValues(
                        updateContainer, filterList(modelChanges, x -> supportedIds.contains(x.getId())), support));


        return modelChanges;
    }

    private Map<? extends StrategyUpdateOperationTypeSupport<? extends BaseStrategy>, Set<Long>>
    getIdsForCleaningGroupedByTypeSupports(
            StrategyUpdateOperationContainer updateContainer,
            Collection<? extends BaseStrategy> oldModels,
            List<? extends ModelChanges<? extends BaseStrategy>> modelChanges) {
        List<StrategyUpdateOperationTypeSupport<? extends BaseStrategy>> supports =
                (List<StrategyUpdateOperationTypeSupport<?
                        extends BaseStrategy>>) getSupports();
        return StreamEx.of(supports)
                .mapToEntry(TypeSupport::getTypeClass)
                .mapValues(supportClass ->
                        getIdsForCleaning(updateContainer, oldModels, modelChanges, supportClass))
                .removeValues(Set::isEmpty)
                .toMap();

    }

    private <M extends BaseStrategy> void addModelChangesForCleaningUnsupportedTypeValues(
            StrategyUpdateOperationContainer updateContainer,
            List<? extends ModelChanges<? extends BaseStrategy>> modelChanges,
            StrategyUpdateOperationTypeSupport<M> support) {
        List<ModelChanges<M>> typedModelChanges = castModelChanges(support.getTypeClass(), modelChanges);
        support.addModelChangesForCleaningUnsupportedTypeValues(updateContainer, typedModelChanges);
    }

    private Set<Long> getIdsForCleaning(
            StrategyUpdateOperationContainer updateContainer,
            Collection<? extends BaseStrategy> oldModels,
            List<? extends ModelChanges<? extends BaseStrategy>> modelChanges,
            Class<? extends BaseStrategy> supportClass) {
        Set<Long> affectedIds = listToSet(modelChanges, ModelChanges::getId);
        Set<Long> oldIdsAffectedBySupport = StreamEx.of(oldModels)
                .filter(model -> affectedIds.contains(model.getId()))
                .filter(model -> supportClass.isAssignableFrom(model.getClass()))
                .map(BaseStrategy::getId)
                .toSet();
        return StreamEx.of(modelChanges)
                .filter(mc -> oldIdsAffectedBySupport.contains(mc.getId()))
                .filter(mc -> !getTypeSupportAffectionHelper().isModelChangesAffectsSupport(updateContainer, mc,
                        supportClass))
                .map(ModelChanges::getId)
                .toSet();
    }


}
