package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpaperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetAvgCpaPerFilterAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<AutobudgetAvgCpaPerFilter>() {
    override fun getTypeClass(): Class<AutobudgetAvgCpaPerFilter> = AutobudgetAvgCpaPerFilter::class.java

    override fun validate(container: StrategyAddOperationContainer, vr: ValidationResult<List<AutobudgetAvgCpaPerFilter>, Defect<*>>): ValidationResult<List<AutobudgetAvgCpaPerFilter>, Defect<*>> {
        val validator = AutobudgetAvgCpaPerFilterValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
