package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpaperfilter;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetAvgCpaPerFilterRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetAvgCpaPerFilter> {

    protected AutobudgetAvgCpaPerFilterRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetAvgCpaPerFilter> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        AutobudgetAvgCpaPerFilter.FILTER_AVG_CPA,
                        STRATEGIES.STRATEGY_DATA,
                        "filter_avg_cpa"
                )).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetAvgCpaPerFilter> getTypeClass() {
        return AutobudgetAvgCpaPerFilter.class;
    }
}
