package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpaperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class AutobudgetAvgCpaPerFilterToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<AutobudgetAvgCpaPerFilter> {
    override fun fillCampaignTypeSpecificFields(
        strategy: AutobudgetAvgCpaPerFilter,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: AutobudgetAvgCpaPerFilter,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = AutobudgetAvgCpaPerFilter::class.java

    private fun fill(strategyData: StrategyData, strategy: AutobudgetAvgCpaPerFilter) {
        strategyData.filterAvgCpa = strategy.filterAvgCpa
    }
}
