package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpaperfilter

import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.StrategyValidatorConstantsBuilder
import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.core.entity.strategy.validation.validators.FilterAvgCpaOrAvgCpiValidator
import ru.yandex.direct.utils.CommonUtils.nvl
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object AutobudgetAvgCpaPerFilterValidatorProvider : AbstractStrategyValidatorProvider<AutobudgetAvgCpaPerFilter>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<AutobudgetAvgCpaPerFilter, Defect<*>> =
        Validator { autobudgetAvgCpaPerFilter: AutobudgetAvgCpaPerFilter ->
            val validator = buildValidator(container, autobudgetAvgCpaPerFilter)
            val vb = ModelItemValidationBuilder.of(autobudgetAvgCpaPerFilter)

            vb.item(AutobudgetAvgCpaPerFilter.FILTER_AVG_CPA).checkBy(validator)

            vb.result
        }

    private fun buildValidator(container: AbstractStrategyOperationContainer,
                               autobudgetAvgCpaPerFilter: AutobudgetAvgCpaPerFilter): FilterAvgCpaOrAvgCpiValidator {
        val validationContainer = FilterAvgCpaOrAvgCpiValidator.Companion.ValidationContainer(
            container.currency,
            nvl(autobudgetAvgCpaPerFilter.isPayForConversionEnabled, false),
            container.availableFeatures,
            StrategyValidatorConstantsBuilder.build(container.campaignType(autobudgetAvgCpaPerFilter), container.currency),
            autobudgetAvgCpaPerFilter.sum
        )
        return FilterAvgCpaOrAvgCpiValidator(validationContainer)
    }
}
