package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpaperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToAutobudgetAvgCpaPerFilterConverterSupport :
    CampaignToStrategyConverterSupport<AutobudgetAvgCpaPerFilter> {
    override fun fillTypeSpecificFields(
        strategy: AutobudgetAvgCpaPerFilter,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.filterAvgCpa = campaign.strategy.strategyData.filterAvgCpa
    }

    override fun getTypeClass() = AutobudgetAvgCpaPerFilter::class.java
}
