package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpcperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetAvgCpcPerFilterAddValidationTypeSupport :
    AbstractStrategyAddValidationTypeSupport<AutobudgetAvgCpcPerFilter>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<AutobudgetAvgCpcPerFilter>, Defect<*>>
    ): ValidationResult<List<AutobudgetAvgCpcPerFilter>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(AutobudgetAvgCpcPerFilterValidatorProvider.createAddStrategyValidator(container))
            .result

    override fun getTypeClass(): Class<AutobudgetAvgCpcPerFilter> = AutobudgetAvgCpcPerFilter::class.java
}
