package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpcperfilter;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetAvgCpcPerFilterRepositoryTypeSupport
        extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetAvgCpcPerFilter> {

    protected AutobudgetAvgCpcPerFilterRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetAvgCpcPerFilter> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        AutobudgetAvgCpcPerFilter.FILTER_AVG_BID,
                        STRATEGIES.STRATEGY_DATA,
                        "filter_avg_bid"
                        )
                ).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetAvgCpcPerFilter> getTypeClass() {
        return AutobudgetAvgCpcPerFilter.class;
    }
}
