package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpcperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class AutobudgetAvgCpcPerFilterToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<AutobudgetAvgCpcPerFilter> {
    override fun fillCampaignTypeSpecificFields(
        strategy: AutobudgetAvgCpcPerFilter,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: AutobudgetAvgCpcPerFilter,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = AutobudgetAvgCpcPerFilter::class.java

    private fun fill(strategyData: StrategyData, strategy: AutobudgetAvgCpcPerFilter) {
        strategyData.filterAvgBid = strategy.filterAvgBid
    }
}
