package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpcperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetAvgCpcPerFilterUpdateValidationTypeSupport :
    AbstractStrategyUpdateValidationTypeSupport<AutobudgetAvgCpcPerFilter>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<MutableList<AutobudgetAvgCpcPerFilter>, Defect<*>>
    ): ValidationResult<List<AutobudgetAvgCpcPerFilter>, Defect<*>> {
        val validator = AutobudgetAvgCpcPerFilterValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<AutobudgetAvgCpcPerFilter> = AutobudgetAvgCpcPerFilter::class.java
}
