package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpcperfilter

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.core.entity.strategy.validation.validators.AvgBidValidator
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object AutobudgetAvgCpcPerFilterValidatorProvider : AbstractStrategyValidatorProvider<AutobudgetAvgCpcPerFilter>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        Validator { strategy: AutobudgetAvgCpcPerFilter ->
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(AutobudgetAvgCpcPerFilter.FILTER_AVG_BID)
                .checkBy(AvgBidValidator(container.currency, strategy.sum, strategy.bid, container.campaignType(strategy)))

            vb.result
        }
}
