package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpcperfilter

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToAutobudgetAvgCpcPerFilterConverterSupport :
    CampaignToStrategyConverterSupport<AutobudgetAvgCpcPerFilter> {
    override fun fillTypeSpecificFields(
        strategy: AutobudgetAvgCpcPerFilter,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.filterAvgBid = campaign.strategy.strategyData.filterAvgBid
    }

    override fun getTypeClass() = AutobudgetAvgCpcPerFilter::class.java
}
