package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_CPI_GOAL_ID
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.service.add.AbstractStrategyAddOperationTypeSupport

@Component
class AutobudgetAvgCpiAddOperationTypeSupport : AbstractStrategyAddOperationTypeSupport<AutobudgetAvgCpi>() {
    override fun getTypeClass() = AutobudgetAvgCpi::class.java

    override fun onPreValidated(addContainer: StrategyAddOperationContainer, models: List<AutobudgetAvgCpi>) {
        models.forEach {
            if (addContainer.campaignType(it) == CampaignType.MOBILE_CONTENT && it.goalId == DEFAULT_CPI_GOAL_ID) {
                it.withGoalId(null);
            }
        }
    }
}
