package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetAvgCpiAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<AutobudgetAvgCpi>() {
    override fun getTypeClass(): Class<AutobudgetAvgCpi> = AutobudgetAvgCpi::class.java

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<AutobudgetAvgCpi>, Defect<*>>): ValidationResult<List<AutobudgetAvgCpi>, Defect<*>> {
        val validator = AutobudgetAvgCpiValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
