package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetAvgCpiRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetAvgCpi> {

    protected AutobudgetAvgCpiRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetAvgCpi> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        AutobudgetAvgCpi.AVG_CPI,
                        STRATEGIES.STRATEGY_DATA,
                        "avg_cpi"
                )).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetAvgCpi> getTypeClass() {
        return AutobudgetAvgCpi.class;
    }
}
