package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class AutobudgetAvgCpiToCampaignConverterSupport : StrategyToCampaignConverterSupport<AutobudgetAvgCpi> {
    override fun fillCampaignTypeSpecificFields(
        strategy: AutobudgetAvgCpi,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: AutobudgetAvgCpi,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = AutobudgetAvgCpi::class.java

    private fun fill(strategyData: StrategyData, strategy: AutobudgetAvgCpi) {
        strategyData.avgCpi = strategy.avgCpi
    }
}
