package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_CPI_GOAL_ID
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.service.update.AbstractStrategyUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges

@Component
class AutobudgetAvgCpiUpdateOperationTypeSupport : AbstractStrategyUpdateOperationTypeSupport<AutobudgetAvgCpi>() {
    override fun getTypeClass() = AutobudgetAvgCpi::class.java

    override fun onChangesApplied(
        updateContainer: StrategyUpdateOperationContainer,
        appliedChanges: MutableList<AppliedChanges<AutobudgetAvgCpi>>) {
        appliedChanges.forEach {
            val strategy = it.model;
            if (updateContainer.campaignType(strategy) == CampaignType.MOBILE_CONTENT && strategy.goalId == DEFAULT_CPI_GOAL_ID) {
                it.modify(AutobudgetAvgCpi.GOAL_ID, null);
            }
        }
    }
}
