package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi

import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.StrategyValidatorConstantsBuilder
import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.core.entity.strategy.validation.validators.FilterAvgCpaOrAvgCpiValidator
import ru.yandex.direct.utils.CommonUtils.nvl
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object AutobudgetAvgCpiValidatorProvider : AbstractStrategyValidatorProvider<AutobudgetAvgCpi>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<AutobudgetAvgCpi, Defect<*>> =
        Validator { autobudgetAvgCpi: AutobudgetAvgCpi ->
            val validator = buildValidator(container, autobudgetAvgCpi)
            val vb = ModelItemValidationBuilder.of(autobudgetAvgCpi)

            vb.item(AutobudgetAvgCpi.AVG_CPI)
                .checkBy(validator)

            vb.result
        }

    private fun buildValidator(container: AbstractStrategyOperationContainer, autobudgetAvgCpi: AutobudgetAvgCpi): FilterAvgCpaOrAvgCpiValidator {
        val validationContainer = FilterAvgCpaOrAvgCpiValidator.Companion.ValidationContainer(
            container.currency,
            nvl(autobudgetAvgCpi.isPayForConversionEnabled, false),
            container.availableFeatures,
            StrategyValidatorConstantsBuilder.build(container.campaignType(autobudgetAvgCpi), container.currency),
            autobudgetAvgCpi.sum
        )
        return FilterAvgCpaOrAvgCpiValidator(validationContainer)
    }
}
