package ru.yandex.direct.core.entity.strategy.type.autobudgetavgcpi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToAutobudgetAvgCpiConverterSupport : CampaignToStrategyConverterSupport<AutobudgetAvgCpi> {
    override fun fillTypeSpecificFields(
        strategy: AutobudgetAvgCpi,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.avgCpi = campaign.strategy.strategyData.avgCpi
    }

    override fun getTypeClass() = AutobudgetAvgCpi::class.java
}
