package ru.yandex.direct.core.entity.strategy.type.autobudgetcrr;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLong;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetCrrRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetCrr> {

    protected AutobudgetCrrRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetCrr> createMapper() {
        return baseBuilder()
                .map(jsonLong(
                        AutobudgetCrr.CRR,
                        STRATEGIES.STRATEGY_DATA,
                        "crr"
                )).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetCrr> getTypeClass() {
        return AutobudgetCrr.class;
    }
}
