package ru.yandex.direct.core.entity.strategy.type.autobudgetcrr

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetCrrUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<AutobudgetCrr>() {
    override fun getTypeClass(): Class<AutobudgetCrr> = AutobudgetCrr::class.java

    override fun validate(container: StrategyUpdateOperationContainer, vr: ValidationResult<List<AutobudgetCrr>, Defect<*>>): ValidationResult<List<AutobudgetCrr>, Defect<*>> {
        val validator = AutobudgetCrrValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}

