package ru.yandex.direct.core.entity.strategy.type.autobudgetcrr

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object AutobudgetCrrValidatorProvider : AbstractStrategyValidatorProvider<AutobudgetCrr>() {
    
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<AutobudgetCrr, Defect<*>> =
        Validator { autobudgetCrr: AutobudgetCrr ->
            val vb = ModelItemValidationBuilder.of(autobudgetCrr)

            vb.item(AutobudgetCrr.CRR).checkBy(CrrValidator)

            vb.result
        }
}
