package ru.yandex.direct.core.entity.strategy.type.autobudgetcrr

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToAutobudgetCrrConverterSupport : CampaignToStrategyConverterSupport<AutobudgetCrr> {
    override fun fillTypeSpecificFields(
        strategy: AutobudgetCrr,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.crr = campaign.strategy.strategyData.crr
    }

    override fun getTypeClass() = AutobudgetCrr::class.java
}
