package ru.yandex.direct.core.entity.strategy.type.autobudgetcrr

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.CRR_MAX
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.CRR_MIN
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.inRange
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object CrrValidator : Validator<Long, Defect<*>> {

    override fun apply(t: Long?): ValidationResult<Long, Defect<*>> =
        ModelItemValidationBuilder.of<Long?, Defect<*>>(t)
            .check(notNull())
            .check(inRange(CRR_MIN, CRR_MAX))
            .result
}
