package ru.yandex.direct.core.entity.strategy.type.autobudgetmedia;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetMedia;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLocalDate;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetMediaRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetMedia> {

    protected AutobudgetMediaRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetMedia> createMapper() {
        return baseBuilder()
                .map(jsonLocalDate(
                        AutobudgetMedia.DATE,
                        STRATEGIES.STRATEGY_DATA,
                        "date"
                )).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetMedia> getTypeClass() {
        return AutobudgetMedia.class;
    }
}
