package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetRoiAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<AutobudgetRoi>() {
    override fun getTypeClass(): Class<AutobudgetRoi> = AutobudgetRoi::class.java

    override fun validate(container: StrategyAddOperationContainer, vr: ValidationResult<List<AutobudgetRoi>, Defect<*>>): ValidationResult<List<AutobudgetRoi>, Defect<*>> {
        val validator = AutobudgetRoiValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
