package ru.yandex.direct.core.entity.strategy.type.autobudgetroi;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLong;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetRoiRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetRoi> {

    protected AutobudgetRoiRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetRoi> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        AutobudgetRoi.ROI_COEF,
                        STRATEGIES.STRATEGY_DATA,
                        "roi_coef"
                ))
                .map(jsonBigDecimal(
                        AutobudgetRoi.PROFITABILITY,
                        STRATEGIES.STRATEGY_DATA,
                        "profitability"
                ))
                .map(jsonLong(
                        AutobudgetRoi.RESERVE_RETURN,
                        STRATEGIES.STRATEGY_DATA,
                        "reserve_return"
                ))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetRoi> getTypeClass() {
        return AutobudgetRoi.class;
    }
}
