package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class AutobudgetRoiToCampaignConverterSupport : StrategyToCampaignConverterSupport<AutobudgetRoi> {
    override fun fillCampaignTypeSpecificFields(
        strategy: AutobudgetRoi,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: AutobudgetRoi,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = AutobudgetRoi::class.java

    private fun fill(strategyData: StrategyData, strategy: AutobudgetRoi) {
        strategyData.roiCoef = strategy.roiCoef
        strategyData.profitability = strategy.profitability
        strategyData.reserveReturn = strategy.reserveReturn
    }
}
