package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetRoiUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<AutobudgetRoi>() {
    override fun getTypeClass(): Class<AutobudgetRoi> = AutobudgetRoi::class.java

    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<AutobudgetRoi>, Defect<*>>): ValidationResult<List<AutobudgetRoi>, Defect<*>> {
        val validator = AutobudgetRoiValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
