package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object AutobudgetRoiValidatorProvider : AbstractStrategyValidatorProvider<AutobudgetRoi>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<AutobudgetRoi, Defect<*>> =
        Validator { roiStrategy: AutobudgetRoi ->
            val vb = ModelItemValidationBuilder.of(roiStrategy)

            vb.item(AutobudgetRoi.ROI_COEF).checkBy(RoiCoefValidator)
            vb.item(AutobudgetRoi.PROFITABILITY).checkBy(ProfitabilityValidator, When.notNull())
            vb.item(AutobudgetRoi.RESERVE_RETURN).checkBy(ReserveReturnValidator)

            vb.result
        }
}
