package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToAutobudgetRoiConverterSupport : CampaignToStrategyConverterSupport<AutobudgetRoi> {
    override fun fillTypeSpecificFields(
        strategy: AutobudgetRoi,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        val strategyData = campaign.strategy.strategyData
        strategy.roiCoef = strategyData.roiCoef
        strategy.profitability = strategyData.profitability
        strategy.reserveReturn = strategyData.reserveReturn
    }

    override fun getTypeClass() = AutobudgetRoi::class.java
}
