package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.PROFITABILITY_MAX
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.PROFITABILITY_MIN
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.inRange
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject
import java.math.BigDecimal

object ProfitabilityValidator : Validator<BigDecimal?, Defect<*>> {
    override fun apply(t: BigDecimal?): ValidationResult<BigDecimal?, Defect<*>> =
        validateObject(t) {
            check(notNull())
            check(inRange(PROFITABILITY_MIN, PROFITABILITY_MAX))
        }
}
