package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.RESERVE_RETURN_MAX
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.RESERVE_RETURN_MIN
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.RESERVE_RETURN_STEP
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.incorrectReserveReturn
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Constraint.fromPredicate
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.inRange
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

object ReserveReturnValidator : Validator<Long?, Defect<*>> {
    override fun apply(t: Long?): ValidationResult<Long?, Defect<*>> =
        validateObject(t) {
            check(notNull())
            check(inRange(RESERVE_RETURN_MIN, RESERVE_RETURN_MAX))
            check(isMultipleOfStep(RESERVE_RETURN_STEP))
        }


    private fun isMultipleOfStep(step: Long): Constraint<Long?, Defect<*>> =
        fromPredicate({ reserveReturn: Long? -> reserveReturn != null && reserveReturn % step == 0L }, incorrectReserveReturn())
}
