package ru.yandex.direct.core.entity.strategy.type.autobudgetroi

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.ROI_COEF_MIN
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.notLessThanOrEqualTo
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject
import java.math.BigDecimal

object RoiCoefValidator : Validator<BigDecimal?, Defect<*>> {
    override fun apply(t: BigDecimal?): ValidationResult<BigDecimal?, Defect<*>> =
        validateObject(t) {
            check(notNull())
            check(notLessThanOrEqualTo(ROI_COEF_MIN))
        }
}
