package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetWeekBundleAddValidationTypeSupport :
    AbstractStrategyAddValidationTypeSupport<AutobudgetWeekBundle>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<AutobudgetWeekBundle>, Defect<*>>
    ): ValidationResult<List<AutobudgetWeekBundle>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(AutobudgetWeekBundleValidatorProvider.createAddStrategyValidator(container))
            .result

    override fun getTypeClass(): Class<AutobudgetWeekBundle> = AutobudgetWeekBundle::class.java

}
