package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonLong;

@Component
@ParametersAreNonnullByDefault
public class AutobudgetWeekBundleRepositoryTypeSupport
        extends BaseStrategyDataFieldRepositoryTypeSupport<AutobudgetWeekBundle> {

    protected AutobudgetWeekBundleRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<AutobudgetWeekBundle> createMapper() {
        return baseBuilder()
                .map(jsonLong(AutobudgetWeekBundle.LIMIT_CLICKS, STRATEGIES.STRATEGY_DATA, "limit_clicks"))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<AutobudgetWeekBundle> getTypeClass() {
        return AutobudgetWeekBundle.class;
    }
}
