package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class AutobudgetWeekBundleToCampaignConverterTypeSupport : StrategyToCampaignConverterSupport<AutobudgetWeekBundle> {
    override fun fillCampaignTypeSpecificFields(
        strategy: AutobudgetWeekBundle,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: AutobudgetWeekBundle,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = AutobudgetWeekBundle::class.java

    private fun fill(strategyData: StrategyData, strategy: AutobudgetWeekBundle) {
        strategyData.limitClicks = strategy.limitClicks
    }
}
