package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class AutobudgetWeekBundleUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<AutobudgetWeekBundle>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<List<AutobudgetWeekBundle>, Defect<*>>
    ): ValidationResult<List<AutobudgetWeekBundle>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(AutobudgetWeekBundleValidatorProvider.createUpdateStrategyValidator(container))
            .result

    override fun getTypeClass(): Class<AutobudgetWeekBundle> = AutobudgetWeekBundle::class.java

}
