package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object AutobudgetWeekBundleValidatorProvider : AbstractStrategyValidatorProvider<AutobudgetWeekBundle>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        createValidator(container.currency)

    private fun createValidator(currency: Currency) =
        Validator { strategy: AutobudgetWeekBundle ->
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(AutobudgetWeekBundle.LIMIT_CLICKS)
                .checkBy(LimitClicksValidator(currency))

            vb.result
        }
}
