package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToAutobudgetWeekBundleConverterSupport :
    CampaignToStrategyConverterSupport<AutobudgetWeekBundle> {
    override fun fillTypeSpecificFields(
        strategy: AutobudgetWeekBundle,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.limitClicks = campaign.strategy.strategyData.limitClicks
    }

    override fun getTypeClass() = AutobudgetWeekBundle::class.java
}
